
class TIris ( object ):
  def __init__ ( self ):
    self.InputNodes = 4
    self.EvolvingNodes = 8
    self.OutputNodes = 3
    self.I2EW = [[0.828232,0.793377,0.853032,0.940179],[0.703976,0.656733,0.704962,0.722114],[0.863351,0.658143,0.833474,0.750905],[0.845813,0.776021,0.765416,0.805152],[0.867308,0.765099,0.739415,0.685763],[0.794118,0.789039,0.589896,0.531617],[0.761653,0.641384,0.663414,0.610675],[0.727371,0.710264,0.612516,0.614972]]
    self.E2OW = [[0,0,1],[0,0,1],[0,0,1],[0,0,1],[0,1,0],[1,0,0],[0,1,0],[0.770013,0.503372,0.197485]]

  def __Satlin ( self, Input ):
    if Input > 1.0:
      return 1.0
    else:
      return Input

  def Recall ( self, InputValues ):
    OutputValues = []
    MaxActivation = 0.0
    Winner = 0
    for CurrEvol in range ( 0, 8 ):
      CurrSum = 0.0
      CurrDiff = 0.0
      for CurrInput in range ( 0, 4 ):
        CurrDiff = CurrDiff + abs ( InputValues [ CurrInput ] - self.I2EW [ CurrEvol] [ CurrInput ] )
        CurrSum  = CurrSum + InputValues [ CurrInput ] + self.I2EW [ CurrEvol ] [ CurrInput ]
      Distance = CurrDiff / CurrSum
      CurrActivation = self.__Satlin ( 1.0 - Distance )
      if CurrActivation > MaxActivation:
        MaxActivation = CurrActivation
        Winner = CurrEvol

    for CurrOutput in range ( 0, 3 ):
      OutVal = self.__Satlin ( MaxActivation * self.E2OW [ Winner ] [ CurrOutput ] )
      OutputValues.append ( OutVal )
    
    return OutputValues

