<?

class TIris
{
  var $I2EW;
  var $E2OW;
  var $InputNodes = 4;
  var $EvolvingNodes = 8;
  var $OutputNodes = 3;

  function Satlin ( $Input )
  {
    if ( $Input > 1.0 )
	{
	  return 1.0;
	}
	else
	{
	  return $Input;
	}
  }  

  function TIris ()
  {
    $this->I2EW = array (array (0.828232,0.793377,0.853032,0.940179),array (0.703976,0.656733,0.704962,0.722114),array (0.863351,0.658143,0.833474,0.750905),array (0.845813,0.776021,0.765416,0.805152),array (0.867308,0.765099,0.739415,0.685763),array (0.794118,0.789039,0.589896,0.531617),array (0.761653,0.641384,0.663414,0.610675),array (0.727371,0.710264,0.612516,0.614972));
	$this->E2OW = array (array (0,0,1),array (0,0,1),array (0,0,1),array (0,0,1),array (0,1,0),array (1,0,0),array (0,1,0),array (0.770013,0.503372,0.197485));
  }

  function Recall ( $InputValues )
  {
    $OutputValues = array ();
    $MaxActivation = 0.0;
    $Winner = 0;
    for ( $CurrEvol = 0; $CurrEvol < 8; $CurrEvol++ )
    {
      $CurrSum = 0.0;
	  $CurrDiff = 0.0;
	  for ( $CurrInput = 0; $CurrInput < 4; $CurrInput++ )
	  {
        $CurrDiff += abs ( $InputValues [ $CurrInput ] - $this->I2EW [ $CurrEvol ] [ $CurrInput ] );
		$CurrSum  += $InputValues [ $CurrInput ] + $this->I2EW [ $CurrEvol ] [ $CurrInput ];
	  }
	  $Distance = $CurrDiff / $CurrSum;
      $CurrActivation = $this->Satlin ( 1.0 - $Distance );
      if ( $CurrActivation > $MaxActivation )
      {
        $MaxActivation = $CurrActivation;
        $Winner = $CurrEvol;
      }
      for ( $CurrOutput = 0; $CurrOutput < 3; $CurrOutput++ )
      {
        $OutputValues [ $CurrOutput ] = $this->Satlin ( $MaxActivation * $this->E2OW [ $Winner ] [ $CurrOutput ] );
      }
    }

	return $OutputValues;

  }	
}
?>
