import java.lang.Math;

public class TIris
{
	  private double [][] I2EW;
	  private double [][] E2OW;

	  public final static int InputNodes = 4;
	  public final static int EvolvingNodes = 8;
	  public final static int OutputNodes = 3;

	  private double Satlin ( double Input )
	  {
	    if ( Input > 1.0 )
		{
		  return 1.0;
		}
		else
		{
		  return Input;
		}
	  }

	  public TIris ()
	  {
	    I2EW = new double [][] {{0.828232,0.793377,0.853032,0.940179},{0.703976,0.656733,0.704962,0.722114},{0.863351,0.658143,0.833474,0.750905},{0.845813,0.776021,0.765416,0.805152},{0.867308,0.765099,0.739415,0.685763},{0.794118,0.789039,0.589896,0.531617},{0.761653,0.641384,0.663414,0.610675},{0.727371,0.710264,0.612516,0.614972}};
		E2OW = new double [][] {{0,0,1},{0,0,1},{0,0,1},{0,0,1},{0,1,0},{1,0,0},{0,1,0},{0.770013,0.503372,0.197485}};
	  }

	  public double [] Recall ( double [] InputValues )
	  {
	    double [] OutputValues = new double [ 3 ];
	    double MaxActivation = 0.0;
	    int Winner = 0;
	    for ( int CurrEvol = 0; CurrEvol < 8; CurrEvol++ )
	    {
	      double CurrSum = 0.0;
	      double CurrDiff = 0.0;
	      for ( int CurrInput = 0; CurrInput < 4; CurrInput++ )
	      {
	        CurrDiff += Math.abs ( InputValues [ CurrInput ] - I2EW [ CurrEvol ][ CurrInput ] );
	        CurrSum  += InputValues [ CurrInput ] + I2EW [ CurrEvol ] [CurrInput ];
	      }
	      double Distance = CurrDiff / CurrSum;
	      double CurrActivation = Satlin ( 1.0 - Distance );
	      if ( CurrActivation > MaxActivation )
	      {
	        MaxActivation = CurrActivation;
	        Winner = CurrEvol;
	      }
	    }

	    for ( int CurrOutput = 0; CurrOutput < 3; CurrOutput++ )
	    {
	      OutputValues [ CurrOutput ] = Satlin ( MaxActivation * E2OW [ Winner][ CurrOutput ] );
	    }

	    return OutputValues;
	  }
}
