using System;
using System.IO;

public class TestIris
{
  public static void Main ( string [] args )
  {
	//load the user-specified test data file
    string [] AryStgLines = File.ReadAllLines ( args [ 0 ] );
	
	//create the SECoS object
	TIris Iris = new TIris ();
	
	//process one line of the file at a time
	for ( long LngCurrRow = 0; LngCurrRow < AryStgLines.Length; LngCurrRow++ )
	{
	  //convert the test data into a vector to present to the SECoS
	  string StgCurrLine = AryStgLines [ LngCurrRow ];
	  string[] AryStgDelimiters = new string[] { " " };
      string[] AryStgItems = StgCurrLine.Split(AryStgDelimiters, StringSplitOptions.None);
	  long LngNumItems = AryStgItems.Length;
	  double [] AryDblRow = new double [ LngNumItems ];
	  for ( long LngCurrItem = 0; LngCurrItem < LngNumItems; LngCurrItem++ )
	  {
	    AryDblRow [ LngCurrItem ] = Convert.ToDouble ( AryStgItems [ LngCurrItem ] );
	  } //end for (LngCurrItem)
	
	  //Recall the SECoS
	  double [] AryDblOutput = Iris.Recall ( AryDblRow );
	  
	  //format the output data into a string and write to the console
	  string StgOutput = "";
	  for ( long LngCurrOutput = 0; LngCurrOutput < TIris.OutputNodes; LngCurrOutput++ )
	  {
	    StgOutput = StgOutput + Convert.ToString ( AryDblOutput [ LngCurrOutput ] ) + " ";
	  } //end for (LngCurrOutput)
	  Console.WriteLine ( StgOutput );
	} //end for (LngCurrRow)
  } //end Main
} //end TestIris
