#include <iostream>
#include <fstream>
#include "TIris.h"

using namespace std;

int main ( int argc, char** argv )
{
  //create the SECoS object
  TIris* TestIris = new TIris ();

  //get the number of input neurons
  int NumInputs = TestIris -> InputNodes;

  //get the number of output neurons
  int NumOutputs = TestIris -> OutputNodes;

  //create an array to hold the input vector
  double* InputRow = new double [ NumInputs ];

  //create an array to hold the output vector
  double* OutputRow = new double [ NumOutputs ];

  //open the input file
  ifstream InputFile;
  InputFile.open ( argv [ 1] );

  //loop until the end of the file is reached
  while ( !InputFile.eof () )
  {
    //read each input value into the input vector
    for ( int CurrIn = 0; CurrIn < NumInputs; CurrIn++ )
    {
      InputFile >> InputRow [ CurrIn ];
    } //end for (CurrIn)

    //recall the SECoS
    TestIris -> Recall ( InputRow, OutputRow );

    //write out the output values
    for ( int CurrOut = 0; CurrOut < NumOutputs; CurrOut++ )
    {
      cout << OutputRow [ CurrOut ] << " ";
    } //end for (CurrOut)
    cout << endl;
  } //end while

  //garbage collection
  InputFile.close ();
  delete [] InputRow;
  delete [] OutputRow;
  delete TestIris;

}
