#include <cmath>
#include "TIris.h"

using namespace std;

TIris::TIris ()
{
  double Input2EvolvingWeights [] = {0.828232,0.793377,0.853032,0.940179,0.703976,0.656733,0.704962,0.722114,0.863351,0.658143,0.833474,0.750905,0.845813,0.776021,0.765416,0.805152,0.867308,0.765099,0.739415,0.685763,0.794118,0.789039,0.589896,0.531617,0.761653,0.641384,0.663414,0.610675,0.727371,0.710264,0.612516,0.614972};
  double Evolving2OutputWeights [] = {0,0,1,0,0,1,0,0,1,0,0,1,0,1,0,1,0,0,0,1,0,0.770013,0.503372,0.197485};

  int CurrEvolNdx = 0;
  int CurrOutputNdx = 0;
  for ( int InitEvol = 0; InitEvol < EvolvingNodes; InitEvol++ )
  {
    for ( int InitInput = 0; InitInput < InputNodes; InitInput++ )
    {
      I2EW [ InitInput ] [ InitEvol ] = Input2EvolvingWeights [ CurrEvolNdx ];
      CurrEvolNdx++;
   }
    for ( int InitOutput = 0; InitOutput < OutputNodes; InitOutput++ )
    {
      E2OW [ InitOutput ] [ InitEvol ] = Evolving2OutputWeights [ CurrOutputNdx ];
      CurrOutputNdx++;
    }
  }
}


void TIris::Recall ( double InputValues [ 4 ] , double OutputValues [ 3 ] )
{
  double MaxActivation = 0.0;
  int Winner = 0;
  for ( int CurrEvol = 0; CurrEvol < 8; CurrEvol++ )
  {
    double CurrSum = 0.0;
    double CurrDiff = 0.0;
    for ( int CurrInput = 0; CurrInput < 4; CurrInput++ )
    {
      CurrDiff += fabs ( InputValues [ CurrInput ] - I2EW [ CurrInput ] [ CurrEvol ] );
      CurrSum  += InputValues [ CurrInput ] + I2EW [ CurrInput ] [ CurrEvol ];
    }
    double Distance = CurrDiff / CurrSum;
    double CurrActivation = Satlin ( 1.0 - Distance );
    if ( CurrActivation > MaxActivation )
    {
      MaxActivation = CurrActivation;
      Winner = CurrEvol;
    }
  }

  for ( int CurrOutput = 0; CurrOutput < 3; CurrOutput++ )
  {
    OutputValues [ CurrOutput ] = Satlin ( MaxActivation * E2OW [ CurrOutput ] [ Winner ] );
  }
}
